#pragma once
#include <fstream>
#include <iostream>
#include <algorithm>
#include "FileException.h"
#include "Struct.h"

using namespace std;
ofstream & operator << (ofstream & file, const Info &info)
{
        file  << endl <<"Library card #: " << info.LibCard;
        file << endl << "Subscriber's surname: " << info.Surname;
        file << endl << "Date of issue : " << info.Date;
        file << endl << "Returning term : " << info.Term;
        file << endl << "Author:  " << info.Author;
        file << endl << "Title: " << info.Title;
        file << endl << "Year of publishing:  " << info.Year;
        file << endl << "Publishing House: " << info.Publishing;
        file << endl << "Price: " << info.Price << endl;;
	return file;
}

void WriteToFile()
{
        Info info;
        ofstream fout;
	int ticket;
        map<int, Info> Map;
	int i = 0;
        while (cout <<endl<< "Input Library card #" << endl << "'0' for end" << endl,
		cin >> ticket, ticket != 0)
	{
                info.LibCard = ticket;
                cout << endl << "Subscriber's surname: ";
		cin >> info.SurnameAb;
                cout << endl << "Date of issue: ";
		cin >> info.Date;
                cout << endl << "Returning term : ";
                cin >> info.Term;
                cout << endl << "Author:  ";
		cin >> info.Author;
                cout << endl << "Title: ";
                cin >> info.Title;
                cout << endl << "Year of publishing:  ";
		cin >> info.Year;
                cout << endl << "Publishing House: ";
		cin >> info.Publishing;
                cout << endl << "Price: ";
		cin >> info.Price;
		cout << endl;
                Map.emplace(i, info);
		i++;
	}
        fout.open("bfile.bin", ios::binary);
        if (!fout.is_open())
	{
                throw FileException("Error opening file");
	}
        for (auto& it : Map)
	{
                fout.write(reinterpret_cast<char*>(&it.second), sizeof(it.second));
	}
        fout.close();
}

void DeleteFromFile(int num)
{
        Info info;
        ifstream bin;
	int i = 0;
        map <int, Info> Map;
        bin.open("bfile.bin", ios::binary);
        while (bin.read(reinterpret_cast<char*> (&info), sizeof(info)))
	{
                Map.emplace(i, info);
		++i;
	}
        Map.erase(num);
        bin.close();
        ofstream bin;
	ofstream filetxt;
        filetxt.open("res.txt");
        bin.open("bfile.bin", ios::binary);
        for (auto& it : Map)
	{
                bin.write(reinterpret_cast<char*>(&it.second), sizeof(it.second));
		filetxt << it.second;
	}


}

void Replace(int number)
{
        Info info;
        Info newinfo;
        ifstream bin;
	int i = 0;
        map <int, Info> Map;
        bin.open("bfile.bin", ios::binary);
        while (bin.read(reinterpret_cast<char*> (&info), sizeof(info)))
	{
                Map.emplace(i, info);
		++i;
	}
	
                cout << endl << "Input LibraryCard number ";
                cin>> newinfo.LibCard;
                cout << endl << "Subscriber's surname: ";
                cin >> info.SurnameAb;
                cout << endl << "Date of issue: ";
                cin >> info.Date;
                cout << endl << "Returning term : ";
                cin >> info.Term;
                cout << endl << "Author:  ";
                cin >> info.Author;
                cout << endl << "Title: ";
                cin >> info.Title;
                cout << endl << "Year of publishing:  ";
                cin >> info.Year;
                cout << endl << "Publishing House: ";
                cin >> info.Publishing;
                cout << endl << "Price: ";
		cin >> info.Price;
		cout << endl;
                Map.emplace(number, newinfo);
        bin.close();
        ofstream bin;
	ofstream txt;
        txt.open("res.txt");
        bin.open("bfile.bin", ios::binary);
        for (auto& it : Map)
	{
                bin.write(reinterpret_cast<char*>(&it.second), sizeof(it.second));
		txt << it.second;
	}

}

void BinaryToText()
{
        Info info;
        ifstream bin("bfile.bin", ios::binary);
        ofstream text("tfile.txt", ios::app);

        while (bin.read(reinterpret_cast<char*> (&info), sizeof(info)))
	{
                text << info;
	}

        bin.close();
        text.close();
}

void FindNumber(int number)
{
        Info info;
        ifstream bin;
	int i = 0;
        map <int, Info> Map;
        bin.open("bfile.bin", ios::binary);
        ofstream fout;
        fout.open("sfile.txt");
        if (!fout.is_open())
	{
                throw FileException("Error opening file");
	}
        while (!bin.eof())
	{
                bin.read(reinterpret_cast<char*> (&info), sizeof(info));
                Map.emplace(i, info);
		++i;
	}
        auto beg = Map.begin();
        auto end = Map.end();
        for (auto pos = Map.begin(); pos != Map.end(); ++pos)
	{
                if (pos->second.LibCard == number)
		{
                        fout << pos->second;
		}
                else cout << "Not found" << endl;

	}
}

void FindAuthor()
{
        Info info;
        ifstream bin;
	string str;
	int i = 0;
        map <int, Info> Map;
        bin.open("bfile.bin", ios::binary);
        ofstream fout;
        fout.open("sfile.txt");
        if (!fout.is_open())
	{
                throw FileException("Error opening file");
	}
        cout << endl << "Input author to search: ";
	cin >> str;
        while (!bin.eof())
	{
                bin.read(reinterpret_cast<char*> (&info), sizeof(info));
                Map.emplace(i, info);
		++i;
	}
        auto beg = Map.begin();
        auto end = Map.end();
        for (auto pos = Map.begin(); pos != Map.end(); ++pos)
	{
		if (pos->second.Author== str)
		{
                        fout << pos->second;
		}
                else cout << "Not found" << endl;

	}
}

void FindPublish()
{
        Info info;
        ifstream bin;
	string str;
	int i = 0;
        map <int, Info> Map;
        bin.open("bfile.bin", ios::binary);
        ofstream fout;
        fout.open("sfile.txt");
        if (!fout.is_open())
	{
                throw FileException("Error opening file");
	}
        cout << endl << "Input publication to search: ";
	cin >> str;
        while (!bin.eof())
	{
                bin.read(reinterpret_cast<char*> (&info), sizeof(info));
                Map.emplace(i, info);
		++i;
	}
        auto beg = Map.begin();
        auto end = Map.end();
        for (auto pos = Map.begin(); pos != Map.end(); ++pos)
	{
		if (pos->second.Publishing==str)
		{
                        fout << pos->second;
		}
                else cout << "Not found" << endl;
	}
}

void FindDate()
{
        Info info;
        ifstream bin;
	string str;
	int i = 0;
        map <int, Info> Map;
        bin.open("bfile.bin", ios::binary);
        ofstream fout;
        fout.open("sfile.txt");
        if (!fout.is_open())
	{
                throw FileException("Error opening file");
	}
        cout << endl << "Input date to search: ";
	cin >> str;
        while (!bin.eof())
	{
                bin.read(reinterpret_cast<char*> (&info), sizeof(info));
                Map.emplace(i, info);
		++i;
	}
        auto beg = Map.begin();
        auto end = Map.end();
        for (auto pos = Map.begin(); pos != Map.end(); ++pos)
	{
		if (pos->second.Date == str)
		{
                        fout << pos->second;
		}
                else cout << "Not found" << endl;
	}
}
